package gov.va.vamf.scheduling.batch.datalayer.reminder;

import com.agilex.healthcare.directscheduling.dao.DAOConstants;
import gov.va.vamf.scheduling.batch.domain.RecallReminder;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecallReminderDaoImpl {
    private RecallReminderStoredProcedure recallReminderStoredProcedure;
    private JdbcTemplate jdbcTemplate;
    private String storedProcedure;
    private RecallReminderResultSetRowMapper recallReminderResultSetRowMapper;

    public void initStoredProcedure() {
        recallReminderStoredProcedure = new RecallReminderStoredProcedure(jdbcTemplate,
            storedProcedure, recallReminderResultSetRowMapper);
    }

    public List<RecallReminder> fetchRecallReminders(Date recallDate) {
        Map<String, Object> inputParamsMap = new HashMap<String, Object>();
        inputParamsMap.put(DAOConstants.RECALL_DATE, recallDate);

        return executeStoredProcedure(inputParamsMap);
    }

    private List<RecallReminder> executeStoredProcedure(Map<String, Object> inputParamsMap) {
        Map<String, Object> storedProcedureResults = recallReminderStoredProcedure.getStoredProcedureResults(inputParamsMap);
        return (List<RecallReminder>) storedProcedureResults.get(DAOConstants.RESULT_LIST);
    }

    public RecallReminderStoredProcedure getRecallReminderStoredProcedure() {
        return recallReminderStoredProcedure;
    }

    public void setRecallReminderStoredProcedure(RecallReminderStoredProcedure recallReminderStoredProcedure) {
        this.recallReminderStoredProcedure = recallReminderStoredProcedure;
    }

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getStoredProcedure() {
        return storedProcedure;
    }

    public void setStoredProcedure(String storedProcedure) {
        this.storedProcedure = storedProcedure;
    }

    public RecallReminderResultSetRowMapper getRecallReminderResultSetRowMapper() {
        return recallReminderResultSetRowMapper;
    }

    public void setRecallReminderResultSetRowMapper(RecallReminderResultSetRowMapper recallReminderResultSetRowMapper) {
        this.recallReminderResultSetRowMapper = recallReminderResultSetRowMapper;
    }
}
